<?php

class WishlistManager
{
    protected $repository;

    public function __construct()
    {
        $this->repository = new WishlistRepository();
    }

    public function addProduct($idCustomer, $idProduct)
    {
        if (!$this->repository->exists($idCustomer, $idProduct)) {
            $this->repository->add($idCustomer, $idProduct);
        }
    }

    public function removeProduct($idCustomer, $idProduct)
    {
        $this->repository->remove($idCustomer, $idProduct);
    }

    public function getProducts($idCustomer)
    {
        return $this->repository->findByCustomer($idCustomer);
    }
}