<?php 

class WhishlistActionModuleFrontController extends ModuleFrontController
{
    public $ajax = true;

    
    public function initContent()
    {
        parent::initContent();
    }

    public function displayAjax()
    {
        $action = Tools::getValue('action');
        $idProduct = (int)Tools::getValue('id_product');

        $manager = new WishlistManager();

        if (!$this->context->customer->isLogged()) {
            die(json_encode(['error' => 'Not logged in']));
        }

        switch ($action) {
            case 'add':
                $manager->addProduct($this->context->customer->id, $idProduct);
                die(json_encode(['success' => true]));
            case 'remove':
                $manager->removeProduct($this->context->customer->id, $idProduct);
                die(json_encode(['success' => true]));
            default:
                die(json_encode(['error' => 'Invalid action']));
        }
    }
}